/*!\file GetVectorFromInputsx
 * \brief retrieve vector from inputs in elements
 */

#include "./GetVectorFromInputsx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void GetVectorFromInputsx( Vector<IssmDouble>** pvector, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters, int name, int type){

	int i;
	Vector<IssmDouble>* vector=NULL;

	if(type==VertexEnum){

		/*Allocate vector*/
		vector=new Vector<IssmDouble>(vertices->NumberOfVertices());

		/*Look up in elements*/
		for(i=0;i<elements->Size();i++){
			Element* element=(Element*)elements->GetObjectByOffset(i);
			element->GetVectorFromInputs(vector,name);
		}

		/*Look up in materials*/
		for(i=0;i<materials->Size();i++){
			Material* material=(Material*)materials->GetObjectByOffset(i);
			material->GetVectorFromInputs(vector,name);
		}
	}
	else{
		_error_("vector type: " << EnumToStringx(type) << " not supported yet!");
	}

	vector->Assemble();

	/*Assign output pointers:*/
	*pvector=vector;
}

void GetVectorFromInputsx( IssmDouble** pvector, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters, int name, int type){
	
	/*output: */
	IssmDouble* vector=NULL;
	
	/*intermediary: */
	Vector<IssmDouble>* vec_vector=NULL;

	GetVectorFromInputsx( &vec_vector, elements,nodes, vertices, loads, materials, parameters, name, type);
	vector=vec_vector->ToMPISerial();

	/*Free ressources:*/
	xdelete(&vec_vector);

	/*Assign output pointers:*/
	*pvector=vector;
}
