/*! \file BoolElementResult.h 
 *  \brief: header file for bool result object
 *  A boll result object is just derived from a BoolInput object, with additional time and step information.
 */


#ifndef _BOOLELEMENTRESULT_H_
#define _BOOLELEMENTRESULT_H_

/*Headers:*/
/*{{{*/
#include "../Inputs/Input.h"
#include "../../../include/include.h"
class Parameters;
/*}}}*/

class BoolElementResult: public ElementResult{

	private: 
		int    enum_type;
		bool   value;
		int    step;
		IssmDouble time;

	public:

		/*BoolElementResult constructors, destructors: {{{*/
		BoolElementResult();
		BoolElementResult(int enum_type,bool value,int step,IssmDouble time);
		~BoolElementResult();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*ElementResult virtual functions definitions: {{{*/
		ElementResult* SpawnTriaElementResult(int* indices);
		IssmDouble  GetTime(void){return time;};
		int     GetStep(void){return step;};
		void    ProcessUnits(Parameters* parameters);
		int     NumberOfNodalValues(void);
		void    PatchFill(int row, Patch* patch);
		/*}}}*/
		/*BoolElementResult management: {{{*/
		int   InstanceEnum();
		void GetVectorFromResults(Vector<IssmDouble>* vector,int* doflist,int* connectivitylist,int numdofs);
		void GetElementVectorFromResults(Vector<IssmDouble>* vector,int dof);
		/*}}}*/
};
#endif  /* _BOOLELEMENTRESULT_H */
