/*!\file SpcStatic.c
 * \brief: implementation of the SpcStatic object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../../../include/include.h"
#include "../../../shared/shared.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../Container/Container.h"
#include "../objects.h"

/*SpcStatic constructors and destructor*/
/*FUNCTION SpcStatic::SpcStatic(){{{*/
SpcStatic::SpcStatic(){
	return;
}
/*}}}*/
/*FUNCTION SpcStatic::SpcStatic(int spc_sid,int spc_nodeid,...){{{*/
SpcStatic::SpcStatic(int spc_sid,int spc_nodeid, int spc_dof,IssmDouble spc_value,int spc_analysis_type){

	sid=spc_sid;
	nodeid=spc_nodeid;
	dof=spc_dof;
	value=spc_value;
	analysis_type=spc_analysis_type;

	return;
}
/*}}}*/
/*FUNCTION SpcStatic::~SpcStatic{{{*/
SpcStatic::~SpcStatic(){
	return;
}
/*}}}*/
		
/*Object virtual functions definitions:*/
/*FUNCTION SpcStatic::Echo {{{*/
void SpcStatic::Echo(void){

	_printLine_("SpcStatic:");
	_printLine_("   sid: " << sid);
	_printLine_("   nodeid: " << nodeid);
	_printLine_("   dof: " << dof);
	_printLine_("   value: " << value);
	_printLine_("   analysis_type: " << EnumToStringx(analysis_type));
	return;
}
/*}}}*/
/*FUNCTION SpcStatic::DeepEcho {{{*/
void SpcStatic::DeepEcho(void){

	_printLine_("SpcStatic:");
	_printLine_("   sid: " << sid);
	_printLine_("   nodeid: " << nodeid);
	_printLine_("   dof: " << dof);
	_printLine_("   value: " << value);
	_printLine_("   analysis_type: " << EnumToStringx(analysis_type));
	return;
}		
/*}}}*/
/*FUNCTION SpcStatic::Id {{{*/
int    SpcStatic::Id(void){ return sid; }
/*}}}*/
/*FUNCTION SpcStatic::MyRank {{{*/
int    SpcStatic::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION SpcStatic::ObjectEnum{{{*/
int SpcStatic::ObjectEnum(void){

	return SpcStaticEnum;

}
/*}}}*/
/*FUNCTION SpcStatic::copy {{{*/
Object* SpcStatic::copy() {
	return new SpcStatic(*this); 
}
/*}}}*/

/*Constraint virtual functions definitions: */
/*FUNCTION SpcStatic::InAnalysis{{{*/
bool SpcStatic::InAnalysis(int in_analysis_type){
	if (in_analysis_type==this->analysis_type) return true;
	else return false;
}
/*}}}*/
/*FUNCTION SpcStatic::ConstrainNode{{{*/
void SpcStatic::ConstrainNode(Nodes* nodes,Parameters* parameters){

	Node* node=NULL;

	/*Chase through nodes and find the node to which this SpcStatic applys: */
	node=(Node*)nodes->GetObjectById(NULL,nodeid);

	/*Apply constraint: */
	if(node){ //in case the spc is dealing with a node on another cpu
		node->ApplyConstraint(dof,value);
	}
}
/*}}}*/

/*SpcStatic functions*/
/*FUNCTION SpcStatic::GetDof {{{*/
int SpcStatic::GetDof(){
	return dof;
}
/*}}}*/
/*FUNCTION SpcStatic::GetNodeId {{{*/
int   SpcStatic::GetNodeId(){
	
	return nodeid;
}
/*}}}*/
/*FUNCTION SpcStatic::GetValue {{{*/
IssmDouble SpcStatic::GetValue(){
	_assert_(!xIsNan<IssmDouble>(value));
	return value;
}
/*}}}*/
