md=triangle(model,'../Exp/Square.exp',150000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md.materials=matdamageice();
md.materials.rheology_B=paterson(md.initialization.temperature);
md.materials.rheology_n=3*ones(md.mesh.numberofelements,1);
md.materials.rheology_Z=0.5*ones(md.mesh.numberofvertices,1);
md=setflowequation(md,'macayeal','all');

%control parameters
md.inversion.iscontrol=1;
md.inversion.control_parameters={'MaterialsRheologyZbar'};
md.inversion.min_parameters=10^-13*ones(md.mesh.numberofvertices,1);
md.inversion.max_parameters=ones(md.mesh.numberofvertices,1);
md.inversion.nsteps=2;
md.inversion.cost_functions=101*ones(md.inversion.nsteps,1);
md.inversion.cost_functions_coefficients=ones(md.mesh.numberofvertices,1);
md.inversion.gradient_scaling=0.9*ones(md.inversion.nsteps,1);
md.inversion.maxiter_per_step=2*ones(md.inversion.nsteps,1);
md.inversion.step_threshold=0.99*ones(md.inversion.nsteps,1);
md.inversion.vx_obs=md.initialization.vx; 
md.inversion.vy_obs=md.initialization.vy;

md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient' 'Misfits' 'MaterialsRheologyZbar' 'Pressure' 'Vel' 'Vx' 'Vy'};
field_tolerances={1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12,1e-12};
field_values={...
   (md.results.DiagnosticSolution.Gradient1),...
   md.results.DiagnosticSolution.J,...
   (md.results.DiagnosticSolution.MaterialsRheologyZbar),...
   (md.results.DiagnosticSolution.Pressure),...
   (md.results.DiagnosticSolution.Vel),...
   (md.results.DiagnosticSolution.Vx),...
   (md.results.DiagnosticSolution.Vy)
};
