from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',180000)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md.extrude(3,2)
md=setflowequation(md,'pattyn','all')
md.cluster=generic('name',oshostname(),'np',3)
md.diagnostic.requested_outputs=StressTensorEnum()
md=solve(md,DiagnosticSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vz','Vel','Pressure',\
	'StressTensorxx','StressTensoryy','StressTensorzz','StressTensorxy','StressTensorxz','StressTensoryz']
field_tolerances=[1e-09,1e-09,1e-09,1e-09,1e-09,\
	1e-09,1e-09,1e-09,1e-09,1e-09,1e-09]
field_values=[\
	md.results['DiagnosticSolution'][1]['Vx'],\
	md.results['DiagnosticSolution'][1]['Vy'],\
	md.results['DiagnosticSolution'][1]['Vz'],\
	md.results['DiagnosticSolution'][1]['Vel'],\
	md.results['DiagnosticSolution'][1]['Pressure'],\
	md.results['DiagnosticSolution'][1]['StressTensorxx'],\
	md.results['DiagnosticSolution'][1]['StressTensoryy'],\
	md.results['DiagnosticSolution'][1]['StressTensorzz'],\
	md.results['DiagnosticSolution'][1]['StressTensorxy'],\
	md.results['DiagnosticSolution'][1]['StressTensorxz'],\
	md.results['DiagnosticSolution'][1]['StressTensoryz'],\
	]
