/*\file TriaSearch.c
 *\brief: TriaSearch module. See TriaSearchx for more details.
 */
#include "./TriaSearch.h"

void TriaSearchUsage(void){/*{{{*/
	_pprintLine_("TriaSearch- find triangle holding a point (x0,y0) in a mesh");
	_pprintLine_("");
	_pprintLine_("   Usage:");
	_pprintLine_("         tria=TriaSearch(index,x,y,x0,y0);");
	_pprintLine_("      index,x,y: mesh triangulatrion");
	_pprintLine_("      x0,y0: coordinates of the point for which we are trying to find a triangle");
	_pprintLine_("      x0,y0 can be an array of points");
	_pprintLine_("");
}/*}}}*/
WRAPPER(TriaSearch){

	int i;

	/*input: */
	int*    index=NULL;
	int     nel;
	int     dummy;

	double* x=NULL;
	double* y=NULL;
	int     nods;

	double* x0=NULL;
	double* y0=NULL;
	int     numberofnodes;

	/* output: */
	double*  tria=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&TriaSearchUsage);

	/*Input datasets: */
	FetchData(&index,&nel,&dummy,INDEXHANDLE);
	FetchData(&x,&nods,XHANDLE);
	FetchData(&y,&nods,YHANDLE);
	FetchData(&x0,&numberofnodes,X0HANDLE);
	FetchData(&y0,&numberofnodes,Y0HANDLE);

	/* Run core computations: */
	TriaSearchx(&tria,index,nel,x,y,nods,x0,y0,numberofnodes);

	/* c to matlab: */
	for(i=0;i<numberofnodes;i++)tria[i]++;

	/*Write data: */
	WriteData(TRIA,tria,numberofnodes);

	/*end module: */
	MODULEEND();
}
