/*\file EnumToString.c
 *\brief:convert enum (int) to string
 */

#include "./EnumToString.h"

void EnumToStringUsage(void){/*{{{*/
	_pprintLine_("");
	_pprintLine_("   usage: " << __FUNCT__ << "string = EnumToString(enum);");
	_pprintLine_("");
}/*}}}*/
WRAPPER(EnumToString){

	char    *name    = NULL;
	int      enum_in;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments: */
	CHECKARGUMENTS(NLHS,NRHS,&EnumToStringUsage);

	/*Fetch inputs: */
	FetchData(&enum_in,ENUMIN);

	/*Run core function: */
	EnumToStringx(&name,enum_in);

	/* output: */
	WriteData(NAME,name);

	/*end module: */
	MODULEEND();
}
