#module imports
from fielddisplay import fielddisplay

class radaroverlay(object):
	"""
	RADAROVERLAY class definition

	   Usage:
	      radaroverlay=radaroverlay();
	"""

	#properties
	def __init__(self):
		# {{{ Properties
		self.pwr = float('NaN')
		self.x   = float('NaN')
		self.y   = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self):
		# {{{ Display
		string='   radaroverlay parameters:'
		string="%s\n\n%s"%(string,fielddisplay(self,'pwr','radar power image (matrix)'))
		string="%s\n%s"%(string,fielddisplay(self,'x','corresponding x coordinates'))
		string="%s\n%s"%(string,fielddisplay(self,'y','corresponding y coordinates'))
		return string
		#}}}
		
	def setdefaultparameters(self):
		# {{{setdefaultparameters
		return self
	#}}}

