class bamgmesh(object):
	"""
	BAMGMESH class definition

	   Usage:
	      bamgmesh(varargin)
	"""

	def __init__(self,*args):    # {{{
		self.Vertices=[]
		self.Edges=[]
		self.Triangles=[]
		self.Quadrilaterals=[]
		self.IssmEdges=[]
		self.IssmSegments=[]
		self.VerticesOnGeomVertex=[]
		self.VerticesOnGeomEdge=[]
		self.EdgesOnGeomEdge=[]
		self.SubDomains=[]
		self.SubDomainsFromGeom=[]
		self.ElementConnectivity=[]
		self.NodalConnectivity=[]
		self.NodalElementConnectivity=[]
		self.CrackedVertices=[]
		self.CrackedEdges=[]

		if not len(args):
			# if no input arguments, create a default object
			pass

		elif len(args) == 1:
			object=args[0]
			for field in object.iterkeys():
				if field in vars(self):
					setattr(self,field,object[field])

		else:
			raise TypeError("bamgmesh constructor error message: unknown type of constructor call")
	# }}}

	def __repr__(self):    # {{{
		s ="class '%s' object '%s' = \n" % (type(self),'self')
		s+="    Vertices: %s\n" % str(self.Vertices)
		s+="    Edges: %s\n" % str(self.Edges)
		s+="    Triangles: %s\n" % str(self.Triangles)
		s+="    Quadrilaterals: %s\n" % str(self.Quadrilaterals)
		s+="    IssmEdges: %s\n" % str(self.IssmEdges)
		s+="    IssmSegments: %s\n" % str(self.IssmSegments)
		s+="    VerticesOnGeomVertex: %s\n" % str(self.VerticesOnGeomVertex)
		s+="    VerticesOnGeomEdge: %s\n" % str(self.VerticesOnGeomEdge)
		s+="    EdgesOnGeomEdge: %s\n" % str(self.EdgesOnGeomEdge)
		s+="    SubDomains: %s\n" % str(self.SubDomains)
		s+="    SubDomainsFromGeom: %s\n" % str(self.SubDomainsFromGeom)
		s+="    ElementConnectivity: %s\n" % str(self.ElementConnectivity)
		s+="    NodalConnectivity: %s\n" % str(self.NodalConnectivity)
		s+="    NodalElementConnectivity: %s\n" % str(self.NodalElementConnectivity)
		s+="    CrackedVertices: %s\n" % str(self.CrackedVertices)
		s+="    CrackedEdges: %s\n" % str(self.CrackedEdges)
		return s
	# }}}

