/*!\file Responsex
 * \brief: compute response according to a response descriptor
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../Container/Container.h"    
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../toolkits/toolkits.h"
#include "./Responsex.h"
#include "../modules.h"

void Responsex(IssmDouble* responses,Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters,const char* response_descriptor,bool process_units,int weight_index){

	int response_descriptor_enum;

	response_descriptor_enum=StringToEnumx(response_descriptor);
	Responsex(responses, elements, nodes,  vertices, loads, materials,  parameters,response_descriptor_enum, process_units, weight_index);

}

void Responsex(IssmDouble* responses,Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters,int response_descriptor_enum,bool process_units,int weight_index){

	switch (response_descriptor_enum){

		#ifdef _HAVE_RESPONSES_
		case IceVolumeEnum:              IceVolumex(               responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MinVelEnum:                 MinVelx(                  responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MaxVelEnum:                 MaxVelx(                  responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MinVxEnum:                  MinVxx(                   responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MaxVxEnum:                  MaxVxx(                   responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MaxAbsVxEnum:               MaxAbsVxx(                responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MinVyEnum:                  MinVyx(                   responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MaxVyEnum:                  MaxVyx(                   responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MaxAbsVyEnum:               MaxAbsVyx(                responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MinVzEnum:                  MinVzx(                   responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MaxVzEnum:                  MaxVzx(                   responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MaxAbsVzEnum:               MaxAbsVzx(                responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case MassFluxEnum:               MassFluxx(                responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case SurfaceAbsVelMisfitEnum:    SurfaceAbsVelMisfitx(     responses, elements,nodes, vertices, loads, materials, parameters,process_units,weight_index); break;
		case SurfaceRelVelMisfitEnum:    SurfaceRelVelMisfitx(     responses, elements,nodes, vertices, loads, materials, parameters,process_units,weight_index); break;
		case SurfaceLogVelMisfitEnum:    SurfaceLogVelMisfitx(     responses, elements,nodes, vertices, loads, materials, parameters,process_units,weight_index); break;
		case SurfaceLogVxVyMisfitEnum:   SurfaceLogVxVyMisfitx(    responses, elements,nodes, vertices, loads, materials, parameters,process_units,weight_index); break;
		case SurfaceAverageVelMisfitEnum:SurfaceAverageVelMisfitx( responses, elements,nodes, vertices, loads, materials, parameters,process_units,weight_index); break;
		case ThicknessAbsMisfitEnum:     ThicknessAbsMisfitx(      responses, elements,nodes, vertices, loads, materials, parameters,process_units,weight_index); break;
		case ThicknessAbsGradientEnum:   ThicknessAbsGradientx(    responses, elements,nodes, vertices, loads, materials, parameters,process_units,weight_index); break;
		case ThicknessAlongGradientEnum:   ThicknessAlongGradientx(    responses, elements,nodes, vertices, loads, materials, parameters,process_units,weight_index); break;
		case ThicknessAcrossGradientEnum:   ThicknessAcrossGradientx(    responses, elements,nodes, vertices, loads, materials, parameters,process_units,weight_index); break;
		case TotalSmbEnum:					TotalSmbx(                responses, elements,nodes, vertices, loads, materials, parameters,process_units); break;
		case RheologyBbarAbsGradientEnum:RheologyBbarAbsGradientx( responses, elements,nodes, vertices, loads, materials, parameters,process_units,weight_index); break;
		case DragCoefficientAbsGradientEnum:DragCoefficientAbsGradientx(responses, elements,nodes, vertices, loads, materials, parameters,process_units,weight_index); break;
		case MaterialsRheologyBbarEnum:ElementResponsex(responses, elements,nodes, vertices, loads, materials, parameters,MaterialsRheologyBbarEnum,process_units); break;
		case VelEnum:ElementResponsex(responses, elements,nodes, vertices, loads, materials, parameters,VelEnum,process_units); break;
		case FrictionCoefficientEnum:NodalValuex(responses, FrictionCoefficientEnum,elements,nodes, vertices, loads, materials, parameters,process_units); break;
		default: _error_("response descriptor \"" << EnumToStringx(response_descriptor_enum) << "\" not supported yet!"); break;
		#else
		default: _error_("ISSM was not compiled with responses capabilities, exiting!");
		#endif
	}

}
