/*!\file RequestedDependentsx
 * \brief: compute outputs that were requested specifically for this solution, such as BasalStress, StrainHeating, etc ...
 */

#include "../../modules/modules.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void RequestedDependentsx(Results* results,Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters){



	int         i;
	int         output_enum;
	bool        isautodiff      = false;
	IssmDouble  output_value;
	Element    *element         = NULL;
	int        *dependent_enums = NULL;

	int         num_dependents;
	IssmPDouble *dependents;

	/*AD mode on?: */
	parameters->FindParam(&isautodiff,AutodiffIsautodiffEnum);

	if(isautodiff){
		#ifdef _HAVE_ADOLC_
		parameters->FindParam(&num_dependents,AutodiffNumDependentsEnum);
		if(num_dependents){
			dependents=xNew<IssmPDouble>(num_dependents);
			parameters->FindParam(&dependent_enums,&num_dependents,AutodiffDependentsEnum);

			/*Go through our dependent variables, and compute the response:*/
			for(i=0;i<num_dependents;i++){
				Responsex(&output_value,elements,nodes,vertices,loads,materials,parameters,dependent_enums[i],false,0);
				output_value>>=dependents[i];
			}
		}
		#else
		_error_("Should not be requesting dependents when an AD library is not available!");
		#endif
	}
}
