/*!\file MaxAbsVzx
 */

#include "./MaxAbsVzx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void MaxAbsVzx( IssmDouble* pmaxabsvz, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){
	
	int i;
	IssmDouble maxabsvz;
	IssmDouble node_maxabsvz;
	IssmDouble element_maxabsvz;

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MaxAbsVz(&element_maxabsvz,process_units); //go pick up the minimum velocity in the inputs
	
		if(i==0)maxabsvz=element_maxabsvz; //initialize maxabsvz
		else{
			if(element_maxabsvz>maxabsvz)maxabsvz=element_maxabsvz;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		maxabsvz=-INFINITY;
	}

	/*Figure out minimum across the cluster: */
	#ifdef _HAVE_MPI_
	MPI_Reduce (&maxabsvz,&node_maxabsvz,1,MPI_DOUBLE,MPI_MAX,0,MPI_COMM_WORLD );
	MPI_Bcast(&node_maxabsvz,1,MPI_DOUBLE,0,MPI_COMM_WORLD);   
	maxabsvz=node_maxabsvz;
	#endif

	/*Assign output pointers:*/
	*pmaxabsvz=maxabsvz;
}
