/*!\file:  Dakotax.h
 * \brief header file for Qmu engine using Dakota
 */ 

#ifndef _DAKOTAX_H
#define _DAKOTAX_H

#include "../../Container/Container.h"
#include "../../classes/classes.h"

/* local prototypes: */
int  SpawnCore(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, void* femmodel,int counter);
int  DescriptorIndex(char* root, int* pindex,char* descriptor);

void Dakotax(FemModel* femmodel);
void SpawnCoreParallel(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, FemModel* femmodel,int counter);
void DakotaResponses(double* responses,char** responses_descriptors,int numresponses,FemModel* femmodel);
void DakotaMPI_Bcast(double** pvariables, char*** pvariables_descriptors,int* pnumvariables, int* pnumresponses);
void DakotaFree(double** pvariables,char*** pvariables_descriptors,char*** presponses_descriptors,int numvariables,int numresponses);

#endif  /* _DAKOTAX_H */
