md=triangle(model,'../Exp/Square.exp',150000);
md=setmask(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=extrude(md,4,1);
md=setflowequation(md,'pattyn','all');
md.cluster=generic('name',oshostname(),'np',3);
md.transient.isdiagnostic=0;
md.transient.isprognostic=0;
md.transient.isthermal=1;
md.transient.isgroundingline=0;
md=solve(md,TransientSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Temperature','BasalforcingsMeltingRate'};
field_tolerances={1e-13,1e-13};
field_values={...
	(md.results.TransientSolution(1).Temperature),...
	(md.results.TransientSolution(1).BasalforcingsMeltingRate),...
	};
