md=triangle(model,'../Exp/Square.exp',150000);
md=meshconvert(md);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=setflowequation(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);
md.prognostic.stabilization=3;
md.prognostic.spcthickness=md.geometry.thickness;
md=solve(md,PrognosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Thickness'};
field_tolerances={1e-13};
field_values={...
	(md.results.PrognosticSolution.Thickness),...
	};
