md=triangle(model,'../Exp/Square.exp',180000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=extrude(md,3,2);
md=setflowequation(md,'stokes','all');
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-08,1e-08,1e-07,1e-08,1e-08};
field_values={...
	(md.results.DiagnosticSolution.Vx),...
	(md.results.DiagnosticSolution.Vy),...
	(md.results.DiagnosticSolution.Vz),...
	(md.results.DiagnosticSolution.Vel),...
	(md.results.DiagnosticSolution.Pressure),...
	};
