/*
	ElementConnectivity.h
*/

#ifndef _ELEMENTCONNECTIVITY_H
#define _ELEMENTCONNECTIVITY_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

/*Header files: */
#include "../../c/include/globals.h"
#include "../../c/toolkits/toolkits.h"
#include "../../c/include/include.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"
#include "../../c/io/io.h"
#include "../../c/EnumDefinitions/EnumDefinitions.h"

#undef __FUNCT__ 
#define __FUNCT__  "ElementConnectivity"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define ELEMENTS         prhs[0]
#define NODECONNECTIVITY prhs[1]
/* serial output macros: */
#define ELEMENTCONNECTIVITY (mxArray**)&plhs[0]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define ELEMENTS         PyTuple_GetItem(args,0)
#define NODECONNECTIVITY PyTuple_GetItem(args,1)
/* serial output macros: */
#define ELEMENTCONNECTIVITY output,0
#endif

/* serial arg counts: */
#undef NLHS
#define NLHS  1
#undef NRHS
#define NRHS  2

#endif  /* _ELEMENTCONNECTIVITY_H */
