/* \file ModuleBoot.cpp
 * \brief Carry out operations needed to boot, for example, petsc, MPI, plapack, etc ... 
 * at the beginning of a module
 */

#include "../../toolkits/toolkits.h"

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

int ModuleBoot(void){
	
	/*Some test for MPI_Init crash with mpich2 1.4 on larsen, just ignore*/
	#ifdef _HAVE_PETSC_
		#if _PETSC_MAJOR_ == 3 && _PETSC_MINOR_ < 1
		if(0){
			int              mp_init = 0;
			PetscErrorCode   ierr;
			extern PetscBool PetscBeganMPI;
			MPI_Initialized(&mp_init); 
			if(mp_init!=1){
				MPI_Init(NULL,NULL); 
				PetscBeganMPI = PETSC_TRUE;
				ierr=PetscInitializeNoArguments();CHKERRQ(ierr);
			} 
		}
		else if (0){
			PetscErrorCode   ierr;
			PetscBool flg;
			ierr=PetscInitialized(&flg);CHKERRQ(ierr);
			if(flg){
				extern PetscBool PetscBeganMPI;
				PetscBeganMPI = PETSC_FALSE;
				ierr=PetscFinalize();CHKERRQ(ierr);
			}
			ierr=PetscInitializeNoArguments();CHKERRQ(ierr);
			ierr=PetscPopSignalHandler();CHKERRQ(ierr);
		}
		#endif

		/*Initialize Petsc: */
		PetscInitializeNoArguments();
	#else
		#ifdef _HAVE_MPI_
		int mp_init = 0;
		MPI_Initialized(&mp_init); 
		if(!mp_init){
			MPI_Init(NULL,NULL); 
		}
		#else
		/*Do nothing*/
		#endif
	#endif
	return 1;
}
