/*!\file ComputeStrainRatex
 * \brief: compute pressure according to each element
 */

#include "./ComputeStrainRatex.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void	ComputeStrainRatex( Vector<IssmDouble>** peps,Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads, Materials* materials,Parameters* parameters){

	/*Intermediary*/
	int i;
	int      found=0;
	int      numberofelements;
	Element* element=NULL;

	/*output: */
	Vector<IssmDouble>* eps=NULL;

	/*Recover numberofelements: */
	parameters->FindParam(&numberofelements,MeshNumberofelementsEnum);

	/*Allocate eps on numberofelements (only 1 dof): */
	eps=new Vector<IssmDouble>(numberofelements);

	/*Compute basal stress for each element: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		element->ComputeStrainRate(eps);
	}

	/*Assemble vector: */
	eps->Assemble();

	/*Assign output pointers: */
	*peps=eps;
	
}
