/*!\file:  AddExternalResultx.cpp
 * \brief: go through our finite elements, and see what results they have stored within. 
 * Then output them into serialized patch arrays, and dump to disk.
 */ 

#include "./AddExternalResultx.h"
#include "../../Container/Container.h"
#include "../../io/io.h"
#include "../../classes/objects/objects.h"
		
void AddExternalResultx( DataSet* results, int enumtype, IssmDouble value){
	/* Add new result in into results*/
	results->AddObject(new GenericExternalResult<double>(results->Size()+1,enumtype,reCast<IssmPDouble>(value),1,0));
}
void AddExternalResultx( DataSet* results, int enumtype, IssmDouble* value, int nrows){
	/* Add new result in into results*/
	#ifdef _HAVE_ADOLC_
	IssmPDouble* value_passive=xNew<IssmPDouble>(nrows);
	for(int i=0;i<nrows;i++)value_passive[i]=reCast<IssmPDouble>(value[i]);
	results->AddObject(new GenericExternalResult<double*>(results->Size()+1,enumtype,value_passive,nrows,1,1,0));
	xDelete<IssmPDouble>(value_passive);
	#else
	results->AddObject(new GenericExternalResult<double*>(results->Size()+1,enumtype,value,nrows,1,1,0));
	#endif
}
