/*!\file MatlabMatrixToMatrix.cpp
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <mex.h>
#include <stdio.h>
#include <string.h>
#include "./matlabio.h"
#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
	
/*}}}*/

Matrix<double>* MatlabMatrixToMatrix(const mxArray* mxmatrix){

	int dummy;
	Matrix<double>* matrix=NULL;

	/*allocate matrix object: */
	matrix=new Matrix<double>();

	#ifdef _HAVE_PETSC_
	matrix->pmatrix=MatlabMatrixToPetscMat(mxmatrix);
	#else
	matrix->smatrix=MatlabMatrixToSeqMat(mxmatrix);
	#endif
	
	return matrix;
}
