/* \file objects.h
 * \brief: prototype header for all objects.
 */

#ifndef ALL_OBJECTS_H_
#define ALL_OBJECTS_H_

/*Abstract classes: */
#include "./Object.h"

/*Objects: */
#include "./Contour.h"
#include "./Vertex.h"
#include "./Node.h"
#include "./Segment.h"

/*Constraints: */
#include "./Constraints/Constraint.h"
#include "./Constraints/SpcStatic.h"
#include "./Constraints/SpcTransient.h"
#include "./Constraints/SpcDynamic.h"

/*Loads: */
#include "./Loads/Load.h"
#include "./Loads/Friction.h"
#include "./Loads/Icefront.h"
#include "./Loads/Numericalflux.h"
#include "./Loads/Riftfront.h"
#include "./Loads/Penpair.h"
#include "./Loads/Pengrid.h"

/*Elements: */
#include "./Elements/Element.h"
#include "./Elements/Penta.h"
#include "./Elements/PentaHook.h"
#include "./Elements/PentaRef.h"
#include "./Elements/Tria.h"
#include "./Elements/TriaHook.h"
#include "./Elements/TriaRef.h"

/*KML parsing objects: */
#include "./KML/KML_Attribute.h"
#include "./KML/KML_Comment.h"
#include "./KML/KML_ColorStyle.h"
#include "./KML/KML_Container.h"
#include "./KML/KML_Document.h"
#include "./KML/KML_Feature.h"
#include "./KML/KML_File.h"
#include "./KML/KML_Folder.h"
#include "./KML/KML_Geometry.h"
#include "./KML/KML_GroundOverlay.h"
#include "./KML/KML_Icon.h"
#include "./KML/KML_LatLonBox.h"
#include "./KML/KML_LinearRing.h"
#include "./KML/KML_LineString.h"
#include "./KML/KML_LineStyle.h"
#include "./KML/KML_MultiGeometry.h"
#include "./KML/KML_Object.h"
#include "./KML/KML_Overlay.h"
#include "./KML/KML_Point.h"
#include "./KML/KML_Placemark.h"
#include "./KML/KML_Polygon.h"
#include "./KML/KML_PolyStyle.h"
#include "./KML/KML_Style.h"
#include "./KML/KML_StyleSelector.h"
#include "./KML/KML_SubStyle.h"
#include "./KML/KML_Unknown.h"
#include "./KML/KMLFileReadUtils.h"

/*Option parsing objects: */
#include "./Options/Option.h"
#include "./Options/GenericOption.h"
#include "./Options/OptionUtilities.h"

/*Inputs: */
#include "./Inputs/Input.h"
#include "./Inputs/BoolInput.h"
#include "./Inputs/DoubleInput.h"
#include "./Inputs/IntInput.h"
#include "./Inputs/PentaP1Input.h"
#include "./Inputs/TriaP1Input.h"
#include "./Inputs/ControlInput.h"
#include "./Inputs/DatasetInput.h"
#include "./Inputs/TransientInput.h"

/*ElementResults: */
#include "./ElementResults/ElementResult.h"
#include "./ElementResults/DoubleElementResult.h"
#include "./ElementResults/TriaP1ElementResult.h"
#include "./ElementResults/PentaP1ElementResult.h" 
#include "./ElementResults/BoolElementResult.h"

/*ExternalResults: */
#include "./ExternalResults/ExternalResult.h"
#include "./ExternalResults/GenericExternalResult.h"

/*Materials: */
#include "./Materials/Material.h"
#include "./Materials/Matice.h"
#include "./Materials/Matdamageice.h"
#include "./Materials/Matpar.h"

/*Params: */
#include "./Params/GenericParam.h"
#include "./Params/BoolParam.h"
#include "./Params/DoubleMatParam.h"
#include "./Params/DoubleTransientMatParam.h"
#include "./Params/DoubleMatArrayParam.h"
#include "./Params/DoubleParam.h"
#include "./Params/DoubleVecParam.h"
#include "./Params/IntParam.h"
#include "./Params/IntVecParam.h"
#include "./Params/IntMatParam.h"
#include "./Params/FileParam.h"
#include "./Params/Param.h"
#include "./Params/MatrixParam.h"
#include "./Params/VectorParam.h"
#include "./Params/StringArrayParam.h"
#include "./Params/StringParam.h"
#include "./Params/TransientParam.h"

#endif
