#!/bin/sh

#petsc 3.2
#mpich 1.4

pythonversion=2.7

./configure \
	--prefix=$ISSM_DIR \
	--with-triangle-dir=$ISSM_DIR/externalpackages/triangle/install \
	--with-python-dir=$ISSM_DIR/externalpackages/python/install\
	--with-python-version=$pythonversion \
	--with-python-numpy-dir=$ISSM_DIR/externalpackages/python/install/lib/python$pythonversion/site-packages/numpy/core/include/numpy\
	--with-metis-dir=$ISSM_DIR/externalpackages/metis/install \
	--with-mpi-include=$ISSM_DIR/externalpackages/mpich2/install/include  \
	--with-mpi-lib=" $ISSM_DIR/externalpackages/mpich2/install/lib/libpmpich.a $ISSM_DIR/externalpackages/mpich2/install/lib/libmpich.a $ISSM_DIR/externalpackages/mpich2/install/lib/libmpl.a " \
	--with-chaco-dir=$ISSM_DIR/externalpackages/chaco/install \
	--with-fortran-lib="/usr/local/gfortran/lib/libgfortran.a" \
	--with-math-lib="/usr/lib/libm.dylib" \
	--with-graphics-lib="/usr/X11/lib/libX11.dylib" \
	--with-cxxoptflags=" -fno-common -no-cpp-precomp -fexceptions -arch x86_64 -mmacosx-version-min=10.5  -O3 -DNDEBUG -w "\
	--with-numthreads=8 \
	--with-petsc-dir=$ISSM_DIR/externalpackages/petsc/install  \
	--with-petsc-arch=$ISSM_ARCH \
	--with-blas-lapack-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-plapack-lib="-L$ISSM_DIR/externalpackages/petsc/install/ -lPLAPACK" \
	--with-plapack-include="-I$ISSM_DIR/externalpackages/petsc/install/include/ " \
	--with-blacs-dir=$ISSM_DIR/externalpackages/petsc/install/ \
	--with-scalapack-dir=$ISSM_DIR/externalpackages/petsc/install/ \
	--with-mumps-dir=$ISSM_DIR/externalpackages/petsc/install/ 
	#--with-dakota-dir=$ISSM_DIR/externalpackages/dakota/install \
	#--with-boost-dir=$ISSM_DIR/externalpackages/boost/install/ \
