#!/bin/sh

#External packages versions:
#petsc 3.1 or 3.2
#mpich 1.4

./configure \
 --prefix=$ISSM_DIR \
 --with-triangle-dir=$ISSM_DIR/externalpackages/triangle/install \
 --with-python-dir=$ISSM_DIR/externalpackages/python/install\
 --with-python-numpy-dir=$ISSM_DIR/externalpackages/python/install/lib/python2.7/site-packages/numpy/core/include/numpy\
 --with-python-version=2.7\
 --with-metis-dir=$ISSM_DIR/externalpackages/metis/install \
 --with-petsc-dir=$ISSM_DIR/externalpackages/petsc/install \
 --with-mpi-include=$ISSM_DIR/externalpackages/mpich2/install/include  \
 --with-mpi-lib="-L$ISSM_DIR/externalpackages/mpich2/install/lib/ -lmpich " \
 --with-petsc-arch=$ISSM_ARCH \
 --with-blas-lapack-dir=$ISSM_DIR/externalpackages/petsc/install \
 --with-blacs-dir=$ISSM_DIR/externalpackages/petsc/install/ \
 --with-mumps-dir=$ISSM_DIR/externalpackages/petsc/install/ \
 --with-fortran-lib="-L/usr/lib/gcc/x86_64-redhat-linux/4.1.1/ -lgfortran" \
 --with-graphics-lib=/usr/lib64/libX11.so \
 --with-cxxoptflags="-march=opteron -O2 -lutil" \
 --with-numthreads=32 \
 --enable-debugging
