import os.path
import numpy
from collections import OrderedDict
from MatlabFuncs import *

def expread(filename):
	"""
	EXPREAD - read a file exp and build a Structure

	   This routine reads a file .exp and build a Structure containing the 
	   fields x and y corresponding to the coordinates, one for the filename of
	   the exp file, for the density, for the nodes, and a field closed to 
	   indicate if the domain is closed. 
	   The first argument is the .exp file to be read and the second one (optional) 
	   indicate if the last point shall be read (1 to read it, 0 not to).

	   Usage:
	      Struct=expread(filename)

	   Example:
	      Struct=expread('domainoutline.exp')
	      Struct=expread('domainoutline.exp')

	   See also EXPDOC, EXPWRITEASVERTICES
	"""

	#some checks
	if not os.path.exists(filename):
		raise OSError("expread error message: file '%s' not found!" % filename)

	#initialize number of profile
	Structs=[]

	#open file
	fid=open(filename,'r')

	#loop over the number of profiles
	while True:

		#update number of profiles
		Struct=OrderedDict()

		#Get file name
		A=fid.readline()
		while A=='\n':
			A=fid.readline()
		if not A:
			break
		A=A.split(None,1)
		if not (len(A) == 2 and strcmp(A[0],'##') and strncmp(A[1],'Name:',5)):
			break
		if len(A[1])>5: 
			Struct['name']=A[1][5:-1]
		else:
			Struct['name']=''

		#Get Icon
		A=fid.readline().split(None,1)
		if not (len(A) == 2 and strcmp(A[0],'##') and strncmp(A[1],'Icon:',5)):
			break

		#Get Info
		A=fid.readline().split()
		if not (len(A) == 4 and strcmp(A[0],'#') and strcmp(A[1],'Points')):
			break

		#Get number of nodes and density
		A=fid.readline().split()
		Struct['nods']   =float(A[0])
		Struct['density']=float(A[1])

		#Get Info
		A=fid.readline().split()
		if not (len(A) == 5 and strcmp(A[0],'#') and strcmp(A[1],'X') and strcmp(A[2],'pos') \
		                                         and strcmp(A[3],'Y') and strcmp(A[4],'pos')):
			break

		#Get Coordinates
		Struct['x']=numpy.empty(Struct['nods'])
		Struct['y']=numpy.empty(Struct['nods'])
		for i in xrange(int(Struct['nods'])):
			A=fid.readline().split()
			Struct['x'][i]=float(A[0])
			Struct['y'][i]=float(A[1])

#		if(Struct['nods']~=length(Struct['x']))error(['Profile ' num2str ' reports incorrect length']); end;

		#Check if closed
		if (Struct['nods'] > 1) and \
		   (Struct['x'][-1] == Struct['x'][0]) and \
		   (Struct['y'][-1] == Struct['y'][0]):
			Struct['closed']=True
		else:
			Struct['closed']=False

		Structs.append(Struct)

	#close file
	fid.close()

	return Structs

