function md=MeshYams(md,velpath,domainoutline);
%MESHYAMS - Build model of Antarctica by refining according to observed velocity error estimator
%
%   Usage:
%      md=MeshYams;

%PIG settings
%{
nsteps=4;
resolution=10000;
hmin=1500;
hmax=10^7;
gradation=3*ones(nsteps,1);
epsilon=10^-0;
scale=1;
%}

%%{
%Antarctica settings
nsteps=6;
resolution=5000;
hmin=300;        %300m
hmax=150*10^3;   %150km
gradation=[1.5*ones(2,1);3*ones(nsteps-2,1)];
epsilon=3*10^-0; %3m/a interpolation error
scale=1;
%%}

%mesh with initial resolution
md=mesh(md,domainoutline,resolution);

%load velocities 
load(velpath);

disp(['First mesh, number of elements: ' num2str(md.numberofelements)]);

%start mesh adaptation
for i=1:nsteps,
	disp(['Iteration #' num2str(i) '/' num2str(nsteps)]);

	%interpolate velocities onto mesh
	disp('   interpolating velocities');
	md.vx_obs=InterpFromGrid(x_m,y_m,vx,md.x,md.y,0)*scale;
	md.vy_obs=InterpFromGrid(x_m,y_m,vy,md.x,md.y,0)*scale;
	md.vel_obs=averaging(md,sqrt(md.vx_obs.^2+md.vy_obs.^2),2);

	%adapt according to velocities
	disp('   adapting');
	md=YamsCall(md,md.vel_obs,hmin,hmax,gradation(i),epsilon);
end
	
disp(['Final mesh, number of elements: ' num2str(md.numberofelements)]);
