/*!\file AutodiffDriversx
 * \brief: compute outputs from the AD mode,  using our dependents and independents, and drivers available in Adolc.
 */

#include <iostream>
#include "../../modules/modules.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/Numerics/adolc_edf.h"


void AutodiffDriversx(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters,Results* results){
	bool isautodiff       = false;
	/*AD mode on?: */
	parameters->FindParam(&isautodiff,AutodiffIsautodiffEnum);
	if(isautodiff){
                #ifdef _HAVE_ADOLC_
	        int  num_dependents;
                parameters->FindParam(&num_dependents,AutodiffNumDependentsEnum);
	        int  num_independents;
                parameters->FindParam(&num_independents,AutodiffNumIndependentsEnum);
                if(!(num_dependents*num_independents)) return;
	        int  numberofvertices;
                parameters->FindParam(&numberofvertices,MeshNumberofverticesEnum);
		/*retrieve state variable: */
                IssmDouble  *axp  = NULL;
		parameters->FindParam(&axp,&num_independents,AutodiffXpEnum);
		/* driver argument */
		double *xp=xNew<double>(num_independents);
		for(int i=0;i<num_independents;i++){
			xp[i]=reCast<double,IssmDouble>(axp[i]);
		}
		/* get the dimension for the solverx arguments*/
                int configuration_type;
		parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
		int solveSize=nodes->NumberOfDofs(configuration_type,FsetEnum);
		int edf_n=solveSize*(solveSize+1), edf_m=solveSize;

		/*get the EDF pointer:*/
		ext_diff_fct *anEDF_for_solverx_p=dynamic_cast<GenericParam<Adolc_edf> * >(parameters->FindParamObject(AdolcParamEnum))->GetParameterValue().myEDF_for_solverx_p;
		
		/*set the forward method function pointers: */
		anEDF_for_solverx_p->zos_forward=EDF_for_solverx;
		anEDF_for_solverx_p->fos_forward=EDF_fos_forward_for_solverx;
		anEDF_for_solverx_p->fov_forward=EDF_fov_forward_for_solverx;
                anEDF_for_solverx_p->fos_reverse=EDF_fos_reverse_for_solverx;
                // anEDF_for_solverx_p->fov_reverse=EDF_fov_reverse_for_solverx;
		/*allocate the space for the parameters to invoke the forward methods:*/
		anEDF_for_solverx_p->dp_x=xNew<double>(edf_n);
		anEDF_for_solverx_p->dp_X=xNew<double>(edf_n);
		anEDF_for_solverx_p->dpp_X=xNew<double>(edf_n, num_independents);
		anEDF_for_solverx_p->dp_y=xNew<double>(edf_m);
		anEDF_for_solverx_p->dp_Y=xNew<double>(edf_m);
		anEDF_for_solverx_p->dpp_Y=xNew<double>(edf_m, num_independents);
		anEDF_for_solverx_p->dp_U=xNew<double>(edf_m);
		anEDF_for_solverx_p->dpp_U=xNew<double>(num_dependents,edf_m);
                anEDF_for_solverx_p->dp_Z=xNew<double>(edf_n);
                anEDF_for_solverx_p->dpp_Z=xNew<double>(num_dependents,edf_n);
		/* Call AD driver:*/
                // single direction:
                double *tangentDir=xNewZeroInit<double>(num_independents);
                unsigned int anIndepNum=55; // <---------- make this selectable via config
                tangentDir[anIndepNum]=1.0;
                double *theJacVecProduct=xNew<double>(num_dependents);
                double *theOutput=xNew<double>(num_dependents);
                for (int i=0; i<num_independents; ++i) {
                  std::cout << "fos_forward xp[" << i << "]=" << xp[i] << std::endl;
                }
                if (fos_forward(1,num_dependents,num_independents, 0, xp, tangentDir, theOutput, theJacVecProduct ))
                  _error_("fos_forward returned non-zero error code");
                results->AddObject(new GenericExternalResult<IssmPDouble*>(results->Size()+1,AutodiffJacobianEnum,theJacVecProduct,num_dependents,1,1,0.0));

#if 0
                double **J=xNew<double>(num_dependents,num_independents);
		jacobian(1,num_dependents,num_independents,xp,J);
                results->AddObject(new GenericExternalResult<IssmPDouble*>(results->Size()+1,AutodiffJacobianEnum,*J,num_independents,num_dependents,1,1,0.0));
                xDelete(J);
#endif

                /* delete the allocated space for the parameters:*/
                xDelete(anEDF_for_solverx_p->dp_x);
                xDelete(anEDF_for_solverx_p->dp_X);
                xDelete(anEDF_for_solverx_p->dpp_X);
                xDelete(anEDF_for_solverx_p->dp_y);
                xDelete(anEDF_for_solverx_p->dp_Y);
                xDelete(anEDF_for_solverx_p->dpp_Y);
                xDelete(anEDF_for_solverx_p->dp_U);
                xDelete(anEDF_for_solverx_p->dpp_U);
                xDelete(anEDF_for_solverx_p->dp_Z);
                xDelete(anEDF_for_solverx_p->dpp_Z);
		/*Free ressources: */
		xDelete(xp);
		xDelete(axp); // did we allocate this?
		#else
		_error_("Should not be requesting AD drivers when an AD library is not available!");
		#endif
	}
}
