/*!\file RequestedOutputsx
 * \brief: compute outputs that were requested specifically for this solution, such as BasalStress, StrainHeating, etc ...
 */

#include "../../modules/modules.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void RequestedOutputsx(Results* results,Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters, int* requested_outputs, int numoutputs){

	int      output_enum;
	int      step;
	IssmDouble   time;
	IssmDouble   output_value;
	Element *element      = NULL;

	/*Get time and step*/
	parameters->FindParam(&step,StepEnum);
	parameters->FindParam(&time,TimeEnum);

	/*retrieve Inputs*/
	if(numoutputs){
		for(int i=0;i<numoutputs;i++){
			output_enum=requested_outputs[i];

			switch(output_enum){

				case IceVolumeEnum:
					Responsex(&output_value,elements,nodes,vertices,loads,materials,parameters,"IceVolume",false,0);
					results->AddObject(new GenericExternalResult<double>(results->Size()+1,IceVolumeEnum,reCast<IssmPDouble>(output_value),step,time));
					break;
				case TotalSmbEnum:
					Responsex(&output_value,elements,nodes,vertices,loads,materials,parameters,"TotalSmb",false,0);
					results->AddObject(new GenericExternalResult<double>(results->Size()+1,TotalSmbEnum,reCast<IssmPDouble>(output_value),step,time));
					break;
				default:
					/*create this output in the element inputs, and then transfer to results:*/
					for(int j=0;j<elements->Size();j++){
						element=(Element*)elements->GetObjectByOffset(j);
						element->RequestedOutput(output_enum,step,time);
					}
					break;
			}
		}
	}
}
