/* \file WriteData.c:
 * \brief: general interface for writing data
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#define NO_IMPORT

#include "../../toolkits/toolkits.h"
#include "../../include/include.h"
#include "../../modules/modules.h"
#include "../../Container/Container.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
PyObject* PyArrayFromCopiedData(int dims[2],double* data);

/*Primitive data types*/
/*FUNCTION WriteData(PyObject* py_tuple,int index,int integer){{{*/
void WriteData(PyObject* py_tuple, int index, int integer){
	
	PyTuple_SetItem(py_tuple, index, PyInt_FromSsize_t(integer));

}/*}}}*/
/*FUNCTION WriteData(PyObject* py_tuple,int index,char* string){{{*/
void WriteData(PyObject* py_tuple, int index, char* string){
	
	PyTuple_SetItem(py_tuple, index, PyUnicode_FromString(string));

}/*}}}*/
/*FUNCTION WriteData(PyObject* py_tuple,int index, double* matrix, int M, int N){{{*/
void WriteData(PyObject* tuple, int index, double* matrix, int M,int N){

	npy_intp dims[2]={0,0};
	PyObject* array=NULL;

	dims[0]=(npy_intp)M;
	dims[1]=(npy_intp)N;
	array=PyArray_SimpleNewFromData(2,dims,NPY_DOUBLE,matrix);

	PyTuple_SetItem(tuple, index, array);
}/*}}}*/

/*ISSM objects*/
/*FUNCTION WriteData(PyObject* py_tuple,int index,BamgGeom* bamggeom){{{*/
void WriteData(PyObject* py_tuple,int index,BamgGeom* bamggeom){

	PyObject* dict=NULL;

	dict=PyDict_New();

	PyDict_SetItemString(dict,"Vertices",PyArrayFromCopiedData(bamggeom->VerticesSize,bamggeom->Vertices));
	PyDict_SetItemString(dict,"Edges",PyArrayFromCopiedData(bamggeom->EdgesSize,bamggeom->Edges));
	PyDict_SetItemString(dict,"TangentAtEdges",PyArrayFromCopiedData(bamggeom->TangentAtEdgesSize,bamggeom->TangentAtEdges));
	PyDict_SetItemString(dict,"Corners",PyArrayFromCopiedData(bamggeom->CornersSize,bamggeom->Corners));
	PyDict_SetItemString(dict,"RequiredVertices",PyArrayFromCopiedData(bamggeom->RequiredVerticesSize,bamggeom->RequiredVertices));
	PyDict_SetItemString(dict,"RequiredEdges",PyArrayFromCopiedData(bamggeom->RequiredEdgesSize,bamggeom->RequiredEdges));
	PyDict_SetItemString(dict,"CrackedEdges",PyArrayFromCopiedData(bamggeom->CrackedEdgesSize,bamggeom->CrackedEdges));
	PyDict_SetItemString(dict,"SubDomains",PyArrayFromCopiedData(bamggeom->SubDomainsSize,bamggeom->SubDomains));

	PyTuple_SetItem(py_tuple, index, dict);
}
/*}}}*/
/*FUNCTION WriteData(PyObject* py_tuple,int index,BamgMesh* bamgmesh){{{*/
void WriteData(PyObject* py_tuple,int index,BamgMesh* bamgmesh){

	PyObject* dict=NULL;

	dict=PyDict_New();

	PyDict_SetItemString(dict,"Vertices",PyArrayFromCopiedData(bamgmesh->VerticesSize,bamgmesh->Vertices));
	PyDict_SetItemString(dict,"Edges",PyArrayFromCopiedData(bamgmesh->EdgesSize,bamgmesh->Edges));
	PyDict_SetItemString(dict,"Triangles",PyArrayFromCopiedData(bamgmesh->TrianglesSize,bamgmesh->Triangles));
	PyDict_SetItemString(dict,"Quadrilaterals",PyArrayFromCopiedData(bamgmesh->QuadrilateralsSize,bamgmesh->Quadrilaterals));
	PyDict_SetItemString(dict,"IssmEdges",PyArrayFromCopiedData(bamgmesh->IssmEdgesSize,bamgmesh->IssmEdges));
	PyDict_SetItemString(dict,"IssmSegments",PyArrayFromCopiedData(bamgmesh->IssmSegmentsSize,bamgmesh->IssmSegments));
	PyDict_SetItemString(dict,"VerticesOnGeomVertex",PyArrayFromCopiedData(bamgmesh->VerticesOnGeomVertexSize,bamgmesh->VerticesOnGeomVertex));
	PyDict_SetItemString(dict,"VerticesOnGeomEdge",PyArrayFromCopiedData(bamgmesh->VerticesOnGeomEdgeSize,bamgmesh->VerticesOnGeomEdge));
	PyDict_SetItemString(dict,"EdgesOnGeomEdge",PyArrayFromCopiedData(bamgmesh->EdgesOnGeomEdgeSize,bamgmesh->EdgesOnGeomEdge));
	PyDict_SetItemString(dict,"SubDomains",PyArrayFromCopiedData(bamgmesh->SubDomainsSize,bamgmesh->SubDomains));
	PyDict_SetItemString(dict,"SubDomainsFromGeom",PyArrayFromCopiedData(bamgmesh->SubDomainsFromGeomSize,bamgmesh->SubDomainsFromGeom));
	PyDict_SetItemString(dict,"ElementConnectivity",PyArrayFromCopiedData(bamgmesh->ElementConnectivitySize,bamgmesh->ElementConnectivity));
	PyDict_SetItemString(dict,"NodalConnectivity",PyArrayFromCopiedData(bamgmesh->NodalConnectivitySize,bamgmesh->NodalConnectivity));
	PyDict_SetItemString(dict,"NodalElementConnectivity",PyArrayFromCopiedData(bamgmesh->NodalElementConnectivitySize,bamgmesh->NodalElementConnectivity));
	PyDict_SetItemString(dict,"CrackedVertices",PyArrayFromCopiedData(bamgmesh->CrackedVerticesSize,bamgmesh->CrackedVertices));
	PyDict_SetItemString(dict,"CrackedEdges",PyArrayFromCopiedData(bamgmesh->CrackedEdgesSize,bamgmesh->CrackedEdges));

	PyTuple_SetItem(py_tuple, index, dict);
}
/*}}}*/
/*FUNCTION PyArrayFromCopiedData(int dims[2],double* data){{{*/
PyObject* PyArrayFromCopiedData(int dims[2],double* data){

	double* pydata;
	npy_intp pydims[2]={0,0};

	/*  note that PyArray_SimpleNewFromData does not copy the data, so that when the original
	object (e.g. bamggeom,bamgmesh) is deleted, the data is gone.  */

	pydims[0]=(npy_intp)dims[0];
	pydims[1]=(npy_intp)dims[1];
	pydata=xNew<IssmDouble>(dims[0]*dims[1]);
	memcpy(pydata,data,dims[0]*dims[1]*sizeof(double));
	return PyArray_SimpleNewFromData(2,pydims,NPY_DOUBLE,pydata);
}
/*}}}*/
/*FUNCTION WriteData(PyObject* py_tuple,int index,SeqMat<double>* matrix){{{*/
void WriteData(PyObject* py_tuple,int index,SeqMat<double>* matrix){
	
	int M,N;
	double* buffer=NULL;
	npy_intp dims[2]={0,0};
	PyObject* array=NULL;
	
	buffer=matrix->ToSerial();
	matrix->GetSize(&M,&N);
	dims[0]=(npy_intp)M;
	dims[1]=(npy_intp)N;
	array=PyArray_SimpleNewFromData(2,dims,NPY_DOUBLE,buffer);
	
	PyTuple_SetItem(py_tuple, index, array);

}/*}}}*/
/*FUNCTION WriteData(PyObject* py_tuple,int index,SeqVec<double>* vector){{{*/
void WriteData(PyObject* tuple,int index,SeqVec<double>* vector){
	
	int M;
	double* buffer=NULL;
	npy_intp dim=10;
	PyObject* array=NULL;
	
	buffer=vector->ToMPISerial();
	vector->GetSize(&M);
	dim=(npy_intp)M;
	array=PyArray_SimpleNewFromData(1,&dim,NPY_DOUBLE,buffer);
	
	PyTuple_SetItem(tuple, index, array);
}
/*}}}*/
