function md=MeshYams
%MESHYAMS - Build model of Antarctica by refining according to observed velocity error estimator
%
%   Usage:
%      md=MeshYams;

%PIG settings
%{
nsteps=4;
resolution=10000;
hmin=1500;
hmax=10^7;
gradation=3*ones(nsteps,1);
epsilon=10^-0;
domainoutline='DomainOutline.exp';
%}

%%{
%Antarctica settings
nsteps=6;
resolution=5000;
hmin=300;        %300m
hmax=150*10^3;   %150km
gradation=[1.5*ones(2,1);3*ones(nsteps-2,1)];
epsilon=3*10^-0; %3m/a interpolation error
domainoutline='EnvDomainOutline200km.exp';
%%}

velpath='/u/wilkes-r1b/larour/ModelData/RignotAntarcticaVelMosaicRampErsAlos/RignotAntVelSmooth.mat'; scale=1;
%velpath='/u/wilkes-r1b/larour/ModelData/RignotAntarcticaVel1km/RignotAntVel.mat'; scale=365*24*3600; %(from m/s to m/yr)
%velpath='/u/wilkes-r1b/larour/ModelData/RignotPigVel1996/RignotPig1996_HoleFree.mat'; scale=1;
%velpath='/proj/ice/larour/Glaciology/Model_Data/RignotAntarcticaVel1km/RignotAntVel';
%velpath='/proj/ice/larour/Glaciology/Model_Data/BamberAntarcticaVel1km/velocity';
%velpath='/proj/ice/larour/Glaciology/Model_Data/mosaicAnt1km_ramp_ers_alos/RignotAntVel';

groundingline='GroundingLine.exp';
icestreams='Icestream.exp';
parameterfile='Basins.par';

%clear data
clear md

%build new model
md=model;

%mesh with initial resolution
md=mesh(md,domainoutline,resolution);
disp(['First mesh, number of elements: ' num2str(md.numberofelements)]);

%load velocities 
load(velpath);

%start mesh adaptation
for i=1:nsteps,
	disp(['Iteration #' num2str(i) '/' num2str(nsteps)]);

	%interpolate velocities onto mesh
	disp('   interpolating velocities');
	md.vx_obs=InterpFromGrid(x_m,y_m,vx,md.x,md.y,0)*scale;
	md.vy_obs=InterpFromGrid(x_m,y_m,vy,md.x,md.y,0)*scale;
	md.vel_obs=averaging(md,sqrt(md.vx_obs.^2+md.vy_obs.^2),2);

	%adapt according to velocities
	disp('   adapting');
	md=YamsCall(md,md.vel_obs,hmin,hmax,gradation(i),epsilon);
end
	
disp(['Final mesh, number of elements: ' num2str(md.numberofelements)]);
md.vx_obs=InterpFromGrid(x_m,y_m,vx,md.x,md.y,0);
md.vy_obs=InterpFromGrid(x_m,y_m,vy,md.x,md.y,0);
md.vel_obs=sqrt(md.vx_obs.^2+md.vy_obs.^2);
return;

%parameterize model
disp('Parameterizing');
md=geography(md,groundingline,icestreams);
md=parameterize(md,parameterfile);

%md.vx_obs=DataInterp(x_m,y_m,vx*md.yts,md.x,md.y);
%md.vy_obs=DataInterp(x_m,y_m,vy*md.yts,md.x,md.y);
%md.vel_obs=sqrt(md.vx_obs.^2+md.vy_obs.^2);
%return;
