#!/bin/bash
set -eu
#Step 1: unzip and install
#Step 2: After Plapack implodes
STEP=2

if [ $STEP -eq 1 ]; then
	#Some cleanup
	rm -rf install petsc-3.2-p3 src
	mkdir install src

	#Download from ISSM server
	$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-3.2-p3.tar.gz' 'petsc-3.2-p3.tar.gz'

	#Untar and move petsc to install directory
	tar -zxvf  petsc-3.2-p3.tar.gz
	mv petsc-3.2-p3/* src/
	rm -rf petsc-3.2-p3

	#configure
	cd src
	./config/configure.py \
		--prefix="$ISSM_DIR/externalpackages/petsc/install" \
		--with-batch=1  \
		--PETSC_ARCH="$ISSM_ARCH" \
		--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
		--with-debugging=0 \
		--with-shared-libraries=1 \
		--with-blas-lapack-dir=/nasa/intel/mkl/10.0.011/ \
		--known-mpi-shared-libraries=1 \
		--with-mpi-lib=/nasa/sgi/mpt/1.25/lib/libmpi.so \
		--with-mpi-include=/nasa/sgi/mpt/1.25/include  \
		--download-mumps=yes \
		--download-scalapack=yes \
		--download-blacs=yes  \
		--download-plapack=yes \
		--FFLAGS=-I/usr/include \
		--with-cc=icc \
		--with-fc=ifort \
		--COPTFLAGS=" -O3 -xS" \
		--FOPTFLAGS=" -O3 -xS" \
		--CXXOPTFLAGS=" -O3 -xS" \
		--with-pic=1
	echo "== Fix Plapack compilation manually (http://issm.jpl.nasa.gov/documentation/faq/petsc32/) =="
	echo "== Then run STEP=2 =="
fi
if [ $STEP -eq 2 ]; then
	cd src
	./config/configure.py \
	 --prefix="$ISSM_DIR/externalpackages/petsc/install" \
	 --with-batch=1  \
	 --PETSC_ARCH="$ISSM_ARCH" \
	 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	 --with-debugging=0 \
	 --with-shared-libraries=1 \
	 --with-blas-lapack-dir=/nasa/intel/mkl/10.0.011/ \
	 --with-mpi-lib=/nasa/sgi/mpt/1.25/lib/libmpi.so \
	 --with-mpi-include=/nasa/sgi/mpt/1.25/include  \
	 --known-mpi-shared-libraries=1 \
	 --download-mumps=yes \
	 --download-scalapack=yes \
	 --download-blacs=yes  \
	 --with-plapack-dir=$ISSM_DIR/externalpackages/petsc/src/$ISSM_ARCH \
	 --download-parmetis=yes \
	 --FFLAGS=-I/usr/include \
	 --with-cc=icc \
	 --with-fc=ifort \
	 --COPTFLAGS=" -O3 -xS" \
	 --FOPTFLAGS=" -O3 -xS" \
	 --CXXOPTFLAGS=" -O3 -xS" \
	 --with-pic=1
	 cat > src/script.queue << EOF
#PBS -S /bin/bash
#PBS -q debug 
#PBS -l select=1:ncpus=1:model=har 
#PBS -l walltime=200 
#PBS -W group_list=s1010 
#PBS -m e 
. /usr/share/modules/init/bash 
module load comp-intel/11.1.046 
module load mpi/mpt.1.25 
module load math/intel_mkl_64_10.0.011 
export PATH="$PATH:." 
export MPI_GROUP_MAX=64 
mpiexec -np 1 ./conftest-linux-gnu-ia64-intel.py
EOF
	echo "== Follow PETSc's instructions"
fi
