md=triangle(model,'../Exp/Square.exp',50000);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=setflowequation(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);
md.diagnostic.requested_outputs=StressTensorEnum;
md.autodiff.isautodiff=true;
md.autodiff.independents={'Thickness','Surface'};
md.autodiff.dependents={'IceVolume'};
md=solve(md,TransientSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vel','Pressure',...
	'StressTensorxx','StressTensoryy','StressTensorxy'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13};
field_values={...
	(md.results.TransientSolution.Vx),...
	(md.results.TransientSolution.Vy),...
	(md.results.TransientSolution.Vel),...
	(md.results.TransientSolution.Pressure),...
	(md.results.TransientSolution.StressTensorxx),...
	(md.results.TransientSolution.StressTensoryy),...
	(md.results.TransientSolution.StressTensorxy),...
	};
