/*\file GriddataMeshToGrid.c
 *\brief: compute diff between observed and modeled velocity
 */

#include "./GriddataMeshToGrid.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int i;

	/*input datasets: */
	double* index=NULL;
	int     nel;
	double* x=NULL;
	int     nods;
	double* y=NULL;
	double* meshdata=NULL;
	double  cornereast;
	double  cornernorth;
	double  xposting;
	double  yposting;
	int     nlines,ncols;
	char*   interpolationtype;
	int     interpolation;
	char*   filterstring=NULL;
	int     filter;
	int     windowsize;
	
	//contours
	int numcontours;
	Contour** contours=NULL;
	Contour*  contouri=NULL;

	/* output datasets: */
	double* griddata=NULL;


	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&GriddataMeshToGridUsage);

	/*Input datasets: */
	FetchData((void**)&index,&nel,NULL,INDEX,"Matrix","Mat");
	FetchData((void**)&x,&nods,NULL,X,"Matrix","Mat");
	FetchData((void**)&y,NULL,NULL,Y,"Matrix","Mat");

	/*Recover list of contours from the 'contours' structure: */
	//number of contours;
	numcontours=mxGetNumberOfElements(CONTOURS);
	//allocate array:
	contours=(Contour**)xmalloc(numcontours*sizeof(Contour*));

	//go through contours, and populate xcontours and ycontours accordingly.
	for(i=0;i<numcontours;i++){
		//allocate
		contouri=(Contour*)xmalloc(sizeof(Contour));
		//retrieve dimension of this contour.
		contouri->nods=(int)mxGetScalar(mxGetField(CONTOURS,i,"nods"));
		//set pointers.
		contouri->x=mxGetPr(mxGetField(CONTOURS,i,"x"));
		contouri->y=mxGetPr(mxGetField(CONTOURS,i,"y"));
		*(contours+i)=contouri;
	}

	FetchData((void**)&meshdata,NULL,NULL,MESHDATA,"Matrix","Mat");
	FetchData((void**)&cornereast,NULL,NULL,CORNEREAST,"Scalar",NULL);
	FetchData((void**)&cornernorth,NULL,NULL,CORNERNORTH,"Scalar",NULL);
	FetchData((void**)&xposting,NULL,NULL,XPOSTING,"Scalar",NULL);
	FetchData((void**)&yposting,NULL,NULL,YPOSTING,"Scalar",NULL);
	FetchData((void**)&nlines,NULL,NULL,NLINES,"Integer",NULL);
	FetchData((void**)&ncols,NULL,NULL,NCOLS,"Integer",NULL);
	FetchData((void**)&interpolationtype,NULL,NULL,INTERPOLATIONTYPE,"String",NULL);
	if (strcmp(interpolationtype,"node")==0){ interpolation=0; } else if (strcmp(interpolationtype,"element")==0){ interpolation=1; } else{ interpolation=-1; }
	FetchData((void**)&filterstring,NULL,NULL,FILTER,"String",NULL);
	if (strcmp(filterstring,"average")==0){ filter=0; } else if (strcmp(filterstring,"nearest")==0){ filter=1; } else{ filter=-1; }
	FetchData((void**)&windowsize,NULL,NULL,WINDOWSIZE,"Integer",NULL);

	/*Call core of computation: */
	GriddataMeshToGridx( &griddata, index,nel,x,y,nods,contours,numcontours,meshdata,cornereast,cornernorth,xposting,yposting,nlines,ncols,interpolation,filter,windowsize);


	/*Write results: */
	WriteData(GRIDDATA,griddata,nlines,ncols,"Matrix","Mat");

	/*Free ressources: */
	//let matlab do this.
	
	/*end module: */
	MODULEEND();
}



void GriddataMeshToGridUsage(void)
{
	_printf_("   usage:\n");
	_printf_("   [rgrid_data]= GriddataMeshToGrid( index,x,y,contours,meshdata,cornereast,cornernorth,xposting,yposting,nlines,ncols,interpolationtype,filter,windowsize)\n");
	_printf_("\n");
	_printf_("   where:\n");
	_printf_("\n");
	_printf_("   index,x,y: delaunay triangulation defining the mesh.\n");
	_printf_("   contours: structure holding sets of vertices making open contours.\n");
	_printf_("   meshdata: vertex values of data to be interpolated.\n");
	_printf_("   cornereast,cornernorth,posting,nlines,ncols: parameters that define the grid\n");
	_printf_("   interpolationtype: either 'node', or 'element'\n");
	_printf_("   filter: 'average','nearest'. \n");
	_printf_("   windowsize: size of filter window, in units of grid.\n");
	_printf_("   rgrid_data: reference pointer to interpolated grid data.\n");
	_printf_("               data for which no value was available is set to -9999  (not NaN, which is platform dependent) value.\n");
}
