/*!\file GriddataMeshToGridx
 * \brief: griddata from a mesh to a regular grid
 */

#include "./GriddataMeshToGridx.h"

#undef __FUNCT__ 
#define __FUNCT__ "GriddataMeshToGridx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"



void GriddataMeshToGridx( double** pgriddata,double*  index,int nel,double* x,double* y,int nods, Contour** contours,int numcontours,
		double* meshdata,double cornereast,double cornernorth,double xposting,double yposting,int nlines,int ncols,
		int interpolation,int filter,int windowsize){

	int			i,j,k,l;
	int         ii,jj;
	int         maxi;

	/*output: */
	double* griddata=NULL;
	int*    sparsity=NULL;
	
	
	/*intermediary: */
	double  cornersouth;
	int     gridi, gridj;
	double  xi,yi,value;
	int     gridi0,gridi1,gridj0,gridj1;
	double* in_nods=NULL;

	/*Contour:*/
	Contour* contouri=NULL;
	int      numgrids;
	double*  xc=NULL;
	double*  yc=NULL;


	


	/*First, allocate griddata: */
	griddata=(double*)xcalloc(nlines*ncols,sizeof(double));
	sparsity=(int*)xcalloc(nlines*ncols,sizeof(int));
	
	/*Build cornersouth: */
	cornersouth=cornernorth-nlines*yposting;

	/*Split according to type of interpolation being carried out: */
	if (interpolation==0){
		maxi=nods;
	}
	else if (interpolation==0){
		maxi=nel;
	}
	else{
		throw ErrorException(__FUNCT__," interpolation type not supported yet!");
	}
	
	/*Go through grids or elements, and for each grid or element, plug meshdata value into gridded data:*/
	for(i=0;i<maxi;i++){
		
		if (interpolation==0){
			xi=x[i];
			yi=y[i];
		}
		else{
			xi=(x[(int)*(index+3*i+0)-1]+ x[(int)*(index+3*i+1)-1]+ x[(int)*(index+3*i+2)-1])/3.0;
			yi=(y[(int)*(index+3*i+0)-1]+ y[(int)*(index+3*i+1)-1]+ y[(int)*(index+3*i+2)-1])/3.0;
		}

		value=meshdata[i];

		/*Find grid cell into which we are plugging value: */
		gridi=(int)floor((yi-cornersouth)/yposting);
		gridj=(int)floor((xi-cornereast)/xposting);

		if (gridi<0)continue;
		if (gridj<0)continue;
		if (gridi>=nlines)continue;
		if (gridj>=ncols)continue;

	
		/*printf("yi %g cornersouth %g posting %g yi-cornersouth %g gridi %i\n",yi,cornersouth,posting,yi-cornersouth,gridi);
		printf("xi %g cornereast %g posting %g xi-cornereast %g gridj %i\n",xi,cornereast,posting,xi-cornereast,gridj);*/

		/*Now, we need a filter box. Ie, build a box around (gridi,gridj): */;
		gridi0=gridi-windowsize;
		if(gridi0<0)gridi0=0;
		gridi1=gridi+windowsize;
		if(gridi1>=nlines)gridi1=nlines-1;

		gridj0=gridj-windowsize;
		if(gridj0<0)gridj0=0;
		gridj1=gridj+windowsize;
		if(gridj1>=ncols)gridj1=ncols-1;

		/*Using this box, we add value in the box. If filter is average, we add 1 to sparsity for each member of this 
		 * box, if filter is nearest, we set 1 to sparisty for each member of this box: */

		if(filter==0){
			/*average: */
			for(ii=gridi0;ii<=gridi1;ii++){
				for(jj=gridj0;jj<=gridj1;jj++){
					*(griddata+ncols*ii+jj) +=value;
					*(sparsity+ncols*ii+jj) +=1;
				}
			}
		}
		else if(filter==1){
			/*nearest: */
			for(ii=gridi0;ii<=gridi1;ii++){
				for(jj=gridj0;jj<=gridj1;jj++){
					*(griddata+ncols*ii+jj)=value;
					*(sparsity+ncols*ii+jj)=1;
				}
			}
		}
	} //for(i=0;i<maxi;i++)
	

	/*Ok, now we have griddata, and sparsity. Divide griddata by sparsity: */
	for(i=0;i<nlines;i++){
		for(j=0;j<ncols;j++){
			if (*(griddata+ncols*i+j)!=0){
				*(griddata+ncols*i+j)= *(griddata+ncols*i+j) / *(sparsity+ncols*i+j);
			}
		}
	}

	/*Ok, last thing, we need to be sure that our filtering did not introduce values outside our original mesh. 
	 *Go through the contours (which are the outer boundaries and holes of the mesh), and anything outside must be 0. 
	 *We need a list of x and y positions for each grid:*/
	x=(double*)xmalloc(nlines*ncols*sizeof(double));
	y=(double*)xmalloc(nlines*ncols*sizeof(double));
	in_nods=(double*)xcalloc(nlines*ncols,sizeof(double));
	for(i=0;i<nlines;i++){
		for(j=0;j<ncols;j++){
			x[i*ncols+j]=cornereast+xposting*j;
			y[i*ncols+j]=cornersouth+yposting*i;
		}
	}
	for (i=0;i<numcontours;i++){
		#ifdef _DEBUG_
			_printf_("Handling contour %i/%i\n",i,numcontours);
		#endif
		contouri=*(contours+i);
		numgrids=contouri->nods;
		xc=contouri->x;
		yc=contouri->y;

		IsInPolySerial(in_nods,xc,yc,numgrids,x,y,nlines*ncols,2);

		if (i==0){
			/*Dealing with domain outline, exclude all grids outside the domain outline : */
			for(k=0;k<nlines;k++){
				for(l=0;l<ncols;l++){
					if (in_nods[k*ncols+l]==0){
						*(griddata+ncols*k+l)=0;
					}
				}
			}
		}
		else{
			/*Dealing with holes, exclude all grids inside holes: */
			for(k=0;k<nlines;k++){
				for(l=0;l<ncols;l++){
					if (in_nods[k*ncols+l]==1)*(griddata+ncols*k+l)=0;
				}
			}
		}

	}


	/*Assign output pointers: */
	*pgriddata=griddata;
}
