/*!\file AutodiffDriversx
 * \brief: compute outputs from the AD mode,  using our dependents and independents, and drivers available in Adolc.
 */

#include "../../modules/modules.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/Numerics/adolc_edf.h"


void AutodiffDriversx(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters,Results* results){

	int  i                  ,j;
	bool isautodiff       = false;
	int  num_dependents;
	int  num_independents;
	int  numberofvertices;

	/*outputs: */
	IssmDouble  *matJ = NULL;
	IssmDouble  *axp  = NULL;
	double     **J    = NULL;
	double      *xp   = NULL;

	/*AD mode on?: */
	parameters->FindParam(&isautodiff,AutodiffIsautodiffEnum);

	if(isautodiff){
		#ifdef _HAVE_ADOLC_
		parameters->FindParam(&num_dependents,AutodiffNumDependentsEnum);
		parameters->FindParam(&num_independents,AutodiffNumIndependentsEnum);
		parameters->FindParam(&numberofvertices,MeshNumberofverticesEnum);

		if(!num_dependents*num_independents) return;
		
		/*retrieve state variable: */
		parameters->FindParam(&axp,&num_independents,AutodiffXpEnum);

		/*allocate driver results: */
		J=xNew<double*>(num_independents);
		xp=xNew<double>(num_independents); 

		for(i=0;i<num_independents;i++){
			J[i]=xNew<double>(num_dependents);
			xp[i]=reCast<double,IssmDouble>(axp[i]);
		}

		// get the dimension for the solverx arguments
		int configuration_type;
		parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
		int solveSize=nodes->NumberOfDofs(configuration_type,FsetEnum);
                int edf_n=solveSize*(solveSize+1), edf_m=solveSize;
		// get the EDF pointer:
		ext_diff_fct *anEDF_for_solverx_p=dynamic_cast<GenericParam<Adolc_edf> * >(parameters->FindParamObject(AdolcParamEnum))->GetParameterValue().myEDF_for_solverx_p;
		// set the forward method function pointers
		anEDF_for_solverx_p->fos_forward=EDF_fos_forward_for_solverx;
                anEDF_for_solverx_p->fov_forward=EDF_fov_forward_for_solverx;
                // allocate the space for the parameters to invoke the forward methods
		anEDF_for_solverx_p->dp_x=xNew<double>(edf_n);
                anEDF_for_solverx_p->dp_X=xNew<double>(edf_n);
                anEDF_for_solverx_p->dpp_X=xNew<double>(edf_n, num_independents);
                anEDF_for_solverx_p->dp_y=xNew<double>(edf_m);
                anEDF_for_solverx_p->dp_Y=xNew<double>(edf_m);
                anEDF_for_solverx_p->dpp_Y=xNew<double>(edf_m, num_independents);
		// Call AD driver:
		jacobian(1,num_dependents,num_independents,xp,J);
		// delete the allocated space for the parameters
		xDelete(anEDF_for_solverx_p->dp_x);
                xDelete(anEDF_for_solverx_p->dp_X);
                xDelete(anEDF_for_solverx_p->dpp_X,edf_n);
                xDelete(anEDF_for_solverx_p->dp_y);
                xDelete(anEDF_for_solverx_p->dp_Y);
                xDelete(anEDF_for_solverx_p->dpp_Y,edf_m);
		/*Add jacobian matrix to results: */
		matJ=xNew<IssmDouble>(num_dependents*num_independents);
		for (i=0;i<num_independents;++i){
			double* rowi=J[i];
			for (j=0;j<num_dependents;++j){
				*(matJ+num_dependents*i+j)=rowi[j];
			}
		}
		results->AddObject(new DoubleMatExternalResult(results->Size()+1,AutodiffJacobianEnum,matJ,num_independents,num_dependents,1,0.0));

		/*Free ressources: */
		xDelete<double*>(J);
		xDelete<double>(xp);
		xDelete<IssmDouble>(matJ);
		xDelete<IssmDouble>(axp);
		#else
		_error_("Should not be requesting AD drivers when an AD library is not available!");
		#endif
	}
}
