/*!\file AutodiffDriversx
 * \brief: compute outputs from the AD mode,  using our dependents and independents, and drivers available in Adolc.
 */

#include "../../modules/modules.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void AutodiffDriversx(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters,Results* results){

	int  i                  ,j;
	bool isautodiff       = false;
	int  num_dependents;
	int  num_independents;
	int  numberofvertices;

	/*outputs: */
	IssmDouble  *matJ = NULL;
	IssmDouble  *axp  = NULL;
	double     **J    = NULL;
	double      *xp   = NULL;

	/*AD mode on?: */
	parameters->FindParam(&isautodiff,AutodiffIsautodiffEnum);

	if(isautodiff){
		#ifdef _HAVE_ADOLC_
		parameters->FindParam(&num_dependents,AutodiffNumDependentsEnum);
		parameters->FindParam(&axp,&num_independents,AutodiffXpEnum);
		parameters->FindParam(&numberofvertices,MeshNumberofverticesEnum);

		if(!num_dependents*num_independents) return;

		/*allocate driver results: */
		J=xNew<double*>(num_independents);
		xp=xNew<double>(num_independents); 

		for(i=0;i<num_independents;i++){
			J[i]=xNew<double>(num_dependents);
			xp[i]=reCast<double,IssmDouble>(axp[i]);
		}

		/*Call AD driver: */
		jacobian(1,num_dependents,num_independents,xp,J);

		/*Add jacobian matrix to results: */
		matJ=xNew<IssmDouble>(num_dependents*num_independents);
		for (i=0;i<num_independents;++i){
			double* rowi=J[i];
			for (j=0;j<num_dependents;++j){
				*(matJ+num_dependents*i+j)=rowi[j];
			}
		}
		results->AddObject(new DoubleMatExternalResult(results->Size()+1,AutodiffJacobianEnum,matJ,num_independents,num_dependents,1,0.0));

		/*Free ressources: */
		xDelete<double*>(J);
		xDelete<double>(xp);
		xDelete<IssmDouble>(matJ);
		xDelete<IssmDouble>(axp);
		#else
		_error_("Should not be requesting AD drivers when an AD library is not available!");
		#endif
	}
}
