/*!\file ModelProcessorx
 * \brief: create datasets using input binary file and a set of requested analyses
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../classes/objects/objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../include/include.h"
#include "../../modules/modules.h"

void ModelProcessorx(Elements** pelements, Nodes** pnodes, Vertices** pvertices, Materials** pmaterials, Constraints** pconstraints, Loads** ploads, Parameters** pparameters, FILE* IOMODEL,char* rootpath,const int solution_type,const int nummodels,const int* analysis_type_list){

	int   i,analysis_type,dim,verbose;
	bool  isthermal,isprognostic,isdiagnostic,isgroundingline,isenthalpy;
	
	/*output: */
	Elements    *elements    = NULL;
	Nodes       *nodes       = NULL;
	Vertices    *vertices    = NULL;
	Materials   *materials   = NULL;
	Constraints *constraints = NULL;
	Loads       *loads       = NULL;
	Parameters  *parameters  = NULL;

	
	/*Initialize IoModel from input file*/
	IoModel* iomodel = new IoModel(IOMODEL);

	/*Fetch parameters: */
	iomodel->Constant(&dim,MeshDimensionEnum);
	iomodel->Constant(&verbose,VerboseEnum);
	iomodel->Constant(&isthermal,TransientIsthermalEnum);
	iomodel->Constant(&isenthalpy,ThermalIsenthalpyEnum);
	iomodel->Constant(&isprognostic,TransientIsprognosticEnum);
	iomodel->Constant(&isdiagnostic,TransientIsdiagnosticEnum);
	iomodel->Constant(&isgroundingline,TransientIsgroundinglineEnum);
	
	SetVerbosityLevel(verbose);

	for(i=0;i<nummodels;i++){

		analysis_type=analysis_type_list[i];

		/*Hack for trasient runs (to be improved)*/
		if(solution_type==TransientSolutionEnum && analysis_type==ThermalAnalysisEnum && dim==2) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==MeltingAnalysisEnum && dim==2) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==EnthalpyAnalysisEnum && dim==2) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==ThermalAnalysisEnum && isthermal==false) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==MeltingAnalysisEnum && isthermal==false) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==EnthalpyAnalysisEnum && isthermal==false) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==ThermalAnalysisEnum && isenthalpy==true) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==MeltingAnalysisEnum && isenthalpy==true) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==EnthalpyAnalysisEnum && isenthalpy==false) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==PrognosticAnalysisEnum && isprognostic==false && isgroundingline==false) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==DiagnosticHorizAnalysisEnum && isdiagnostic==false) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==DiagnosticVertAnalysisEnum && isdiagnostic==false) continue;
		if(solution_type==TransientSolutionEnum && analysis_type==DiagnosticHutterAnalysisEnum && isdiagnostic==false) continue;
		if(solution_type==SteadystateSolutionEnum && analysis_type==ThermalAnalysisEnum && isenthalpy==true) continue;
		if(solution_type==SteadystateSolutionEnum && analysis_type==MeltingAnalysisEnum && isenthalpy==true) continue;
		if(solution_type==SteadystateSolutionEnum && analysis_type==EnthalpyAnalysisEnum && isenthalpy==false) continue;
	
		if(VerboseMProcessor()) _pprintLine_("   creating datasets for analysis " << EnumToStringx(analysis_type));
		CreateDataSets(&elements,&nodes,&vertices,&materials,&constraints,&loads,&parameters,iomodel,rootpath,solution_type,analysis_type,nummodels,i);
	}

	/*Free resources:*/
	delete iomodel;

	/*Assign output pointers:*/
	*pelements=elements;
	*pnodes=nodes;
	*pvertices=vertices;
	*pmaterials=materials;
	*pconstraints=constraints;
	*ploads=loads;
	*pparameters=parameters;

}
