%AUTODIFF class definition
%
%   Usage:
%      autodiff=autodiff();

classdef autodiff
	properties (SetAccess=public) 
		isautodiff = false;
		dependents = {''};
		independents = {''};
	end
	methods
		function obj = autodiff(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   automatic differentiation parameters:'));
			fielddisplay(obj,'isautodiff','indicates if the automatic differentiation is activated');
			fielddisplay(obj,'dependents','list of dependent variables ; ex: {''Thickness'',''FrictionCoefficient''}');
			fielddisplay(obj,'independents','list of independent variables ; ex: {''IceVolume'',''MassFlux''}');
		end % }}}
		function marshall(obj,fid) % {{{

			WriteData(fid,'object',obj,'fieldname','isautodiff','format','Boolean');
			
			%early return
			if ~obj.isautodiff, return; end

			%process dependent variables
			num_dependents=numel(obj.dependents);
			data=zeros(1,num_dependents);
			for i=1:num_dependents,
				data(i)=StringToEnum(obj.dependents{i});
			end
			WriteData(fid,'data',data,'enum',AutodiffDependentsEnum(),'format','DoubleMat','mattype',3);
			WriteData(fid,'data',num_dependents,'enum',AutodiffNumDependentsEnum(),'format','Integer');
			
			%process independent variables
			num_independents=numel(obj.independents);
			data=zeros(1,num_independents);
			for i=1:num_independents,
				data(i)=StringToEnum(obj.independents{i});
			end
			WriteData(fid,'data',data,'enum',AutodiffIndependentsEnum(),'format','DoubleMat','mattype',3);
			WriteData(fid,'data',num_independents,'enum',AutodiffNumIndependentsEnum(),'format','Integer');

		end % }}}
	end
end
