/*!\file: CreateParametersAutodiff.cpp
 * \brief driver for creating parameters dataset, for autodiff analysis.
 */ 

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void CreateParametersAutodiff(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type){
	
	int         i;
	Parameters *parameters       = NULL;
	bool        autodiff_analysis;
	int*        dependents       = NULL;
	int         num_dependents;
	int*        independents       = NULL;
	int         num_independents;
	
	/*Get parameters: */
	parameters=*pparameters;

	/*retrieve some parameters: */
	iomodel->Constant(&autodiff_analysis,AutodiffIsautodiffEnum);

	if(autodiff_analysis){

		/*recover dependents: */
		parameters->AddObject(iomodel->CopyConstantObject(AutodiffNumDependentsEnum));
		iomodel->FetchData(&dependents,NULL,&num_dependents,AutodiffDependentsEnum);
		parameters->AddObject(new IntVecParam(AutodiffDependentsEnum,dependents,num_dependents));
	
		/*recover independents: */
		parameters->AddObject(iomodel->CopyConstantObject(AutodiffNumIndependentsEnum));
		iomodel->FetchData(&independents,NULL,&num_independents,AutodiffIndependentsEnum);
		parameters->AddObject(new IntVecParam(AutodiffIndependentsEnum,independents,num_independents));

	}

	/*Assign output pointer: */
	*pparameters=parameters;
}
