#!/bin/bash
set -eu
PYVERSION=2.7
PYTHON=python${PYVERSION}

# gfortran 4.6 (see ISSM_DIR/externalpackages/gfortran) is necessary for ISSM compilation.
# On OSX 10.6, this recommended version gets installed in /usr/local/gfortran 
export CC=/usr/local/gfortran/bin/gcc
export CXX=/usr/local/gfortran/bin/g++

#download scipy
git clone https://github.com/scipy/scipy.git

#install scipy
cd scipy
python setup.py build
python setup.py install
cd ..
${PYTHON} -c "import scipy; print 'Installed SciPy', scipy.__version__"
${PYTHON} -c "import scipy; scipy.test()"
