#!/bin/bash
set -eu
PYVERSION=2.7
PYTHON=python${PYVERSION}

export CC="gcc -fPIC"
export CXX="g++ -fPIC"
export F77="gfortran -fPIC"
export FC="gfortran -fPIC"
export FFLAGS=-ff2c

#clean up
rm -rf numpy

#download numpy first
export GIT_SSL_NO_VERIFY=true 
git clone https://github.com/numpy/numpy.git

#install numpy
cd numpy
python setup.py build
python setup.py install
cd ..
${PYTHON} -c "import numpy; print 'Installed NumPy', numpy.__version__"
${PYTHON} -c "import numpy; numpy.test()"
