/*!\file:  Solverx.h
 * \brief solver
 */ 

#ifndef _SOLVERX_H
#define _SOLVERX_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../classes/objects/objects.h"

/* local prototypes: */
void	Solverx(Vector<IssmDouble>** puf, Matrix<IssmDouble>* Kff, Vector<IssmDouble>* pf, Vector<IssmDouble>* uf0,Vector<IssmDouble>* df, Parameters* parameters);

#ifdef _HAVE_PETSC_
void	SolverxPetsc(PetscVec** puf, PetscMat* Kff, PetscVec* pf, PetscVec* uf0,PetscVec* df, Parameters* parameters);
void	SolverxPetsc(Vec* puf, Mat Kff, Vec pf, Vec uf0,Vec df, Parameters* parameters);
void  DofTypesToIndexSet(IS* pisv, IS* pisp, Vec df,int typeenum);
#endif

void SolverxSeq(SeqVec<IssmDouble>** puf,SeqMat<IssmDouble>* Kff, SeqVec<IssmDouble>* pf,Parameters* parameters);
void SolverxSeq(IssmPDouble **pX, IssmPDouble *A, IssmPDouble *B,int n);
void SolverxSeq(IssmPDouble *X, IssmPDouble *A, IssmPDouble *B,int n);

#ifdef _HAVE_ADOLC_
void SolverxSeq(IssmDouble *X,IssmDouble *A,IssmDouble *B,int n, Parameters* parameters);
ADOLC_ext_fct EDF_for_solverx;
#endif

#endif  /* _SOLVERX_H */

