#!/bin/bash
set -eu

#version of mpich2
#version=1.0.2p1
version=1.3.1
#version=1.4

#Some cleanup
rm -rf src install mpich2-$version

#Create src and install directories
mkdir src install

#Untar 
tar -zxvf  mpich2-$version.tar.gz

#Move mpich2 into src directory
mv mpich2-$version/* src
rm -rf mpich2-$version

#Configure mpich2
cd src
if [[ "$version" == "1.0.2p1" ]];
then
	make distclean
fi

source ../configure.sh

if [[ "$version" == "1.0.2p1" ]];
then
	#Apply Patch to examples
	patch ./examples/Makefile ../Examples.Makefile.patch
	patch -R ./src/binding/cxx/mpicxx.h ../mpicxx.h.patch
	patch -R ./src/include/mpicxx.h ../mpicxx.h.patch
fi

#Compile mpich2
if [ $# -eq 0 ];
then
	make
else
	make -j $1
fi
make install 

cd ../install/lib
rm -rf *.so
