#!/bin/bash
set -eu

#Some cleanup
rm -rf install
rm -rf modules-3.2.9
mkdir install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/modules-3.2.9.tar.gz' 'modules-3.2.9.tar.gz'

#Untar 
tar -zxvf  modules-3.2.9.tar.gz

#Move modules into src directory

#Configure modules
cd modules-3.2.9
./configure \
	--prefix=$ISSM_DIR/externalpackages/modules/install\
	--with-module-path=$ISSM_DIR/externalpackages/modules/install/modules/files\
	--with-version-path=$ISSM_DIR/externalpackages/modules/install/modules/versions\
	--with-tcl-lib=$ISSM_DIR/externalpackages/tcl/install/Library/Frameworks/Tcl.framework/Versions/8.5\
	--with-tcl-inc=$ISSM_DIR/externalpackages/tcl/install/Library/Frameworks/Tcl.framework/Versions/8.5/Headers\
	--with-tcl-ver=8.5\
	--with-tclx-lib=$ISSM_DIR/externalpackages/tclx/install/lib/tclx8.4\
    --with-tclx-inc=$ISSM_DIR/externalpackages/tclx/install/include\
	--with-tclx-ver=8.4\
	--with-etc-path=$ISSM_DIR/externalpackages/modules/install/modules/etc\
	--with-skel-path=$ISSM_DIR/externalpackages/modules/install/modules/etc/skel\
	--disable-dependency-tracking

#Compile and install modules
if [ -z $1 ]; then
	make
else
	make -j $1
fi
make install
