#!/bin/bash
set -eu

#0: cleanup
#1: install
#2: test

install=2

export ESMF_DIR=$ISSM_DIR/externalpackages/esmf/esmf
export ESMF_COMPILER=gfortran
export ESMF_COMM=mpich2

if [[ $install == "0" ]]; then
	#Some cleanup
	rm -rf esmf_5_2_0rp2
	rm -rf esmf
fi

if [[ $install == "1" ]]; then

	#Download from ISSM server
	$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/esmf_5_2_0rp2_src.tar.gz' 'esmf_5_2_0rp2_src.tar.gz'

	#Untar 
	tar -zxvf  esmf_5_2_0rp2_src.tar.gz


	#Configure esmf
	cd esmf



	#Compile and install esmf
	if [ -z $1 ]; then
		make
		make install
	else
		make -j $1
		make -j $1 install
	fi
fi

if [[ $install == "2" ]]; then
	cd esmf
	if [ -z $1 ]; then
		make all_tests
	else
		make -j $1 all_tests
	fi
fi
