#!/bin/bash
set -eu 

#Some cleanup
rm -rf install cmake-2.8.5
mkdir install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/cmake-2.8.5.tar.gz' 'cmake-2.8.5.tar.gz'

#Untar 
tar -zxvf  cmake-2.8.5.tar.gz

#Move cmake into install directory
mv cmake-2.8.5/* install
rm -rf cmake-2.8.5

#Compile cmake
cd install 
./bootstrap --prefix=$ISSM_DIR/externalpackages/cmake/install
if [ -z $1 ]; then
	make
else 
	make -j $1; 
fi
make install
