/*!\file KMLMeshWrite.h
 * \brief: prototype for KML mesh writer mex module.
 */

#ifndef _KMLMESHWRITE_H
#define _KMLMESHWRITE_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

#include "../../c/include/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"

#undef __FUNCT__ 
#define __FUNCT__  "KMLMeshWrite"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define NAME          prhs[0]
#define NOTES         prhs[1]
#define ELEMHANDLE    prhs[2]
#define NODECONHANDLE prhs[3]
#define LATHANDLE     prhs[4]
#define LNGHANDLE     prhs[5]
#define PARTHANDLE    prhs[6]
#define DATAHANDLE    prhs[7]
#define CMAPHANDLE    prhs[8]
#define FILENAME      prhs[9]
/* serial output macros: */
#define ERRORFLAG (mxArray**)&plhs[0]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define NAME          PyTuple_GetItem(args,0)
#define NOTES         PyTuple_GetItem(args,1)
#define ELEMHANDLE    PyTuple_GetItem(args,2)
#define NODECONHANDLE PyTuple_GetItem(args,3)
#define LATHANDLE     PyTuple_GetItem(args,4)
#define LNGHANDLE     PyTuple_GetItem(args,5)
#define PARTHANDLE    PyTuple_GetItem(args,6)
#define DATAHANDLE    PyTuple_GetItem(args,7)
#define CMAPHANDLE    PyTuple_GetItem(args,8)
#define FILENAME      PyTuple_GetItem(args,9)
/* serial output macros: */
#define ERRORFLAG output,0
#endif

/* serial arg counts: */
#undef NRHS
#define NRHS 10
#undef NLHS
#define NLHS  1

#endif
