/*! \file  ContourtoNodes
    \brief: takes a  contour file, and figures out which nodes  (x,y list)
*/
	
#include "./ContourToNodes.h"

void ContourToNodesUsage(void){/*{{{*/
	_printLine_("   usage:");
	_printLine_("   [flags]=ContourToNodes(x,y,contourname,edgevalue);\n");
	_printLine_("   where:");
	_printLine_("      x,y: list of nodes.");
	_printLine_("      contourname: name of .exp file containing the contours, or resulting structure from call to expread.");
	_printLine_("      interptype: string definining type of interpolation ('element', or 'node').");
	_printLine_("      edgevalue: integer (0, 1 or 2) defining the value associated to the nodes on the edges of the polygons.");
	_printLine_("      flags: vector of flags (0 or 1), of size nods.");
	_printLine_("");
}/*}}}*/
WRAPPER(ContourToNodes){

	int i,j;

	/* required input: */
	int     edgevalue;
	double *x          = NULL;
	double *y          = NULL;
	char   *interptype = NULL;

	/* output: */
	SeqVec<double> *flags = NULL;
	int  nods;

	/*contours*/
	int numcontours;
	mxArray         *matlabstructure = NULL;
	Contour<double> **contours       = NULL;
	Contour<double> *contouri        = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ContourToNodesUsage);
	
	/*Fetch inputs: */
	FetchData(&x,&nods,NULL,XHANDLE);
	FetchData(&y,NULL,NULL,YHANDLE);
	FetchData(&edgevalue,EDGEVALUEHANDLE);

	/*Fetch contours*/
	if(mxIsChar(FILENAME)){
		/*Call expread on filename to build a contour array in the matlab workspace: */
		mexCallMATLAB(1,&matlabstructure,1,(mxArray**)&FILENAME,"expread");
	}
	else{
		/*FILENAME is actually a structure, coming directly from expread: */
		matlabstructure=(mxArray*)FILENAME;
	}

	numcontours=mxGetNumberOfElements(matlabstructure);
	contours=xNew<Contour<double>*>(numcontours);
	for(i=0;i<numcontours;i++){
		//allocate
		contouri=xNew<Contour<double> >(1);
		//retrieve dimension of this contour.
		contouri->nods=(int)mxGetScalar(mxGetField(matlabstructure,i,"nods"));
		//set pointers.
		contouri->x=mxGetPr(mxGetField(matlabstructure,i,"x"));
		contouri->y=mxGetPr(mxGetField(matlabstructure,i,"y"));
		*(contours+i)=contouri;
	}

	/*Run interpolation routine: */
	ContourToNodesx(&flags,x,y,nods,contours,numcontours,edgevalue);

	/* output: */
	WriteData(FLAGS,flags);

	/*end module: */
	MODULEEND();
}
