/*!\file TriaSearch.h
 */

#ifndef _TRIASEARCH_H
#define _TRIASEARCH_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

/* local prototypes: */
void TriaSearchUsage(void);

#include "../../c/include/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"

#undef __FUNCT__ 
#define __FUNCT__  "TriaSearch"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define INDEXHANDLE prhs[0]
#define XHANDLE     prhs[1]
#define YHANDLE     prhs[2]
#define X0HANDLE    prhs[3]
#define Y0HANDLE    prhs[4]

/* serial output macros: */
#define TRIA (mxArray**)&plhs[0]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define INDEXHANDLE PyTuple _GetItem(args,0)
#define XHANDLE     PyTuple _GetItem(args,1)
#define YHANDLE     PyTuple _GetItem(args,2)
#define X0HANDLE    PyTuple _GetItem(args,3)
#define Y0HANDLE    PyTuple _GetItem(args,4)

/* serial output macros: */
#define TRIA output,0
#endif

/* serial arg counts: */
#undef NLHS
#define NLHS  1
#undef NRHS
#define NRHS  5

#endif
