/*!\file Ll2xy.h
 * \brief: prototype for lat/long to x/y coordinate mex module.
 */

#ifndef _LL2XY_H
#define _LL2XY_H

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

/* local prototypes: */
void Ll2xyUsage(void);

#include "../../c/include/globals.h"
#include "../../c/modules/modules.h"
#include "../../c/Container/Container.h"
#include "../../c/shared/shared.h"
#include "../../c/issm-binding.h"

#undef __FUNCT__ 
#define __FUNCT__  "Ll2xy"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define LAT_IN prhs[0]
#define LON_IN prhs[1]
#define SGN_IN prhs[2]
/* serial output macros: */
#define X_OUT (mxArray**)&plhs[0]
#define Y_OUT (mxArray**)&plhs[1]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define LAT_IN PyTuple_GetItem(args,0)
#define LON_IN PyTuple_GetItem(args,1)
#define SGN_IN PyTuple_GetItem(args,2)
/* serial output macros: */
#define X_OUT output,0
#define Y_OUT output,1
#endif

/* serial arg counts: */
#undef NRHS
#define NRHS  3
#undef NLHS
#define NLHS  2

#endif
